import sys
import urllib.parse
import urllib.request
import base64
import xbmcgui
import xbmcaddon
import xbmc
import xbmcvfs
import os
import xbmcplugin

import common  # Gemeinsame Variablen/Funktionen

def verbindungscheck():
    """
    Testet die HTTP-Verbindung mittels HTTP Basic-Auth.
    Bei Erfolg wird eine Erfolgsmeldung angezeigt, andernfalls eine detaillierte Fehlermeldung.
    """
    try:
        ftp_host = common.addon.getSetting("ftp_host").strip()
        ftp_username = common.addon.getSetting("ftp_username").strip()
        ftp_password = common.addon.getSetting("ftp_password").strip()

        xbmc.log(f"[settings.py] Rohdaten - Host: '{ftp_host}', User: '{ftp_username}'", xbmc.LOGDEBUG)

        # Protokoll entfernen, falls vorhanden
        if ftp_host.startswith("http://") or ftp_host.startswith("https://"):
            ftp_host = ftp_host.split("://", 1)[1]
            xbmc.log(f"[settings.py] Host nach Protokollentfernung: '{ftp_host}'", xbmc.LOGDEBUG)

        # Eventuell enthaltene Zugangsdaten entfernen
        if "@" in ftp_host:
            ftp_host = ftp_host.split("@")[-1]
            xbmc.log(f"[settings.py] Host nach @-Bereinigung: '{ftp_host}'", xbmc.LOGDEBUG)

        # Entferne Pfade, Parameter etc.
        ftp_host = ftp_host.split("/")[0].split("?")[0].split("#")[0]
        ftp_host = ftp_host.rstrip(":/ ")
        xbmc.log(f"[settings.py] Endgültiger Hostname: '{ftp_host}'", xbmc.LOGDEBUG)

        if not ftp_username or not ftp_password:
            xbmcgui.Dialog().notification("Fehler", "Benutzername/Passwort fehlt!", xbmcgui.NOTIFICATION_ERROR)
            xbmcplugin.endOfDirectory(common.addon_handle)
            return

        base_path = "/user/downloads/kodiAddon"  # ggf. anpassen
        url = f"https://{ftp_host}{base_path}"
        xbmc.log(f"[settings.py] URL ohne Credentials: {url}", xbmc.LOGDEBUG)

        credentials = f"{ftp_username}:{ftp_password}"
        auth_encoded = base64.b64encode(credentials.encode('utf-8')).decode('utf-8')
        headers = {
            "User-Agent": "Kodi Southpark-Plus Addon",
            "Authorization": f"Basic {auth_encoded}"
        }
        xbmc.log(f"[settings.py] Encoded credentials: {auth_encoded}", xbmc.LOGDEBUG)

        req = urllib.request.Request(url, headers=headers, method="HEAD")
        with urllib.request.urlopen(req, timeout=15) as response:
            status = response.getcode()
            xbmc.log(f"[settings.py] HTTP-Status: {status}", xbmc.LOGDEBUG)

        xbmcgui.Dialog().notification("Verbindung OK", "Verbindungscheck erfolgreich", xbmcgui.NOTIFICATION_INFO)
        xbmcplugin.endOfDirectory(common.addon_handle)
    except urllib.error.HTTPError as e:
        error_msg = f"HTTP-Fehler: {e.code} {e.reason}"
        xbmc.log(f"[settings.py] {error_msg}", xbmc.LOGERROR)
        xbmcgui.Dialog().notification("HTTP-Fehler", error_msg, xbmcgui.NOTIFICATION_ERROR)
        xbmcplugin.endOfDirectory(common.addon_handle)
    except urllib.error.URLError as e:
        error_msg = f"URL-Fehler: {str(e.reason)}"
        xbmc.log(f"[settings.py] {error_msg}", xbmc.LOGERROR)
        xbmcgui.Dialog().notification("URL-Fehler", error_msg, xbmcgui.NOTIFICATION_ERROR)
        xbmcplugin.endOfDirectory(common.addon_handle)
    except Exception as e:
        error_msg = f"Unbekannter Fehler: {str(e)}"
        xbmc.log(f"[settings.py] {error_msg}", xbmc.LOGERROR)
        xbmcgui.Dialog().notification("Kritischer Fehler", error_msg, xbmcgui.NOTIFICATION_ERROR)
        xbmcplugin.endOfDirectory(common.addon_handle)

def clear_cache():
    """
    Löscht den Addon-Cache.
    """
    try:
        cache_path = xbmcvfs.translatePath(f'special://home/userdata/addon_data/{common.addon_id}/cache/')
        if xbmcvfs.exists(cache_path):
            def delete_folder(path):
                dirs, files = xbmcvfs.listdir(path)
                for file in files:
                    file_path = os.path.join(path, file)
                    xbmcvfs.delete(file_path)
                for dir in dirs:
                    dir_path = os.path.join(path, dir)
                    delete_folder(dir_path)
                    xbmcvfs.rmdir(dir_path)
            delete_folder(cache_path)
            xbmcvfs.rmdir(cache_path)
            xbmc.log(f"[settings.py] Cache erfolgreich gelöscht: {cache_path}", xbmc.LOGINFO)
            xbmcgui.Dialog().notification('Cache gelöscht', 'Der Cache wurde erfolgreich gelöscht!', xbmcgui.NOTIFICATION_INFO)
        else:
            xbmc.log(f"[settings.py] Kein Cache gefunden unter: {cache_path}", xbmc.LOGINFO)
            xbmcgui.Dialog().notification('Cache leeren', 'Kein Cache gefunden.', xbmcgui.NOTIFICATION_INFO)
    except Exception as e:
        xbmc.log(f"[settings.py] Fehler beim Löschen des Caches: {str(e)}", xbmc.LOGERROR)
        xbmcgui.Dialog().notification('Cache löschen', 'Fehler beim Löschen des Caches.', xbmcgui.NOTIFICATION_ERROR)
    xbmcplugin.endOfDirectory(common.addon_handle)



def reset_watched_status_movie():
    """
    Setzt die Gesehenen-Inhalte für Filme zurück, indem die Datei
    'watched_status_movies.json' im Addon-Datenverzeichnis gelöscht wird.
    Gibt dem Benutzer eine spezifische Rückmeldung über das Ergebnis.
    """
    # --- Addon-Datenpfad und Handle ermitteln ---
    addon_data_dir = None
    addon_handle = -1

    try:
        # Addon-Objekt holen
        addon = xbmcaddon.Addon()
        addon_name = addon.getAddonInfo('name') # Holt den tatsächlichen Namen
        # Datenpfad ermitteln
        addon_data_dir = xbmcvfs.translatePath(addon.getAddonInfo('profile'))
        # Sicherstellen, dass das Verzeichnis existiert
        if not xbmcvfs.exists(addon_data_dir):
            xbmcvfs.mkdirs(addon_data_dir)
            xbmc.log(f"[{addon_name}] Addon-Datenverzeichnis erstellt: {addon_data_dir}", xbmc.LOGINFO)
    except Exception as e:
        xbmc.log(f"[{addon_name}] Schwerwiegender Fehler: Konnte Addon-Objekt oder Datenpfad nicht ermitteln: {e}", xbmc.LOGERROR)
        xbmcgui.Dialog().notification(
            "Fehler",
            "Addon-Pfad nicht gefunden.",
            xbmcgui.NOTIFICATION_ERROR,
            5000
        )
        return # Funktion hier beenden, da der Pfad essentiell ist

    try:
        # Addon-Handle ermitteln (wird für endOfDirectory benötigt)
        # sys.argv[1] enthält normalerweise das Handle, wenn das Skript als Plugin aufgerufen wird
        if len(sys.argv) >= 2:
             addon_handle = int(sys.argv[1])
    except (IndexError, ValueError):
         xbmc.log(f"[{addon_name}] Konnte Addon-Handle nicht aus sys.argv ermitteln.", xbmc.LOGWARNING)
         addon_handle = -1 # Fallback

    # --- Eigentliche Reset-Logik ---
    watched_status_file = os.path.join(addon_data_dir, 'watched_status_movies.json')
    xbmc.log(f"[{addon_name}] Prüfe/Lösche Gesehen-Status Datei: {watched_status_file}", xbmc.LOGINFO)

    try:
        # 1. Prüfen, ob die Datei existiert
        if xbmcvfs.exists(watched_status_file):
            # 2a. Ja, Datei existiert -> Löschen
            if xbmcvfs.delete(watched_status_file):
                # Erfolgreich gelöscht
                xbmc.log(f"[{addon_name}] Gesehen-Status-Datei erfolgreich gelöscht.", xbmc.LOGINFO)
                xbmcgui.Dialog().notification(
                    f"{addon_name}", # Titel (Addon-Name)
                    "Gesehen-Status wurde zurückgesetzt.", # Nachricht
                    xbmcgui.NOTIFICATION_INFO, # Icon
                    3000 # Anzeigedauer (3 Sek.)
                )
            else:
                # Fehler beim Löschen, obwohl Datei existiert (selten)
                xbmc.log(f"[{addon_name}] Fehler: Konnte existierende Datei nicht löschen: {watched_status_file}", xbmc.LOGERROR)
                xbmcgui.Dialog().notification(
                    f"{addon_name} - Fehler",
                    "Datei gefunden, aber Löschen fehlgeschlagen.",
                    xbmcgui.NOTIFICATION_ERROR,
                    5000
                )
        else:
            # 2b. Nein, Datei existiert nicht
            xbmc.log(f"[{addon_name}] Gesehen-Status-Datei nicht gefunden (Status war bereits zurückgesetzt).", xbmc.LOGINFO)
            xbmcgui.Dialog().notification(
                f"{addon_name}", # Titel (Addon-Name)
                "Nichts zu löschen!", # Nachricht
                xbmcgui.NOTIFICATION_INFO, # Icon
                3000 # Anzeigedauer (3 Sek.)
            )

    except Exception as e:
        # Allgemeine Fehlerbehandlung während des Datei-Checks/Löschens
        xbmc.log(f"[{addon_name}] Fehler beim Prüfen/Löschen der Gesehen-Status-Datei: {e}", xbmc.LOGERROR)
        import traceback
        xbmc.log(traceback.format_exc(), xbmc.LOGERROR) # Loggt den kompletten Traceback
        xbmcgui.Dialog().notification(
            f"{addon_name} - Fehler",
            f"Ein Fehler ist aufgetreten: {e}",
            xbmcgui.NOTIFICATION_ERROR,
            5000
        )

    # --- Abschluss (endOfDirectory) ---
    # Wird oft für Aktionen aus Settings nicht benötigt, aber beibehalten wie im Original
    if addon_handle != -1:
         xbmc.log(f"[{addon_name}] Aufruf von endOfDirectory mit Handle: {addon_handle}", xbmc.LOGDEBUG)
         xbmcplugin.endOfDirectory(addon_handle)
    else:
        xbmc.log(f"[{addon_name}] Kein gültiges Addon-Handle für endOfDirectory.", xbmc.LOGWARNING)





def reset_watched_status_series():
    """
    Setzt die Gesehenen-Inhalte für Filme zurück, indem die Datei
    'watched_status_series.json' im Addon-Datenverzeichnis gelöscht wird.
    Gibt dem Benutzer eine spezifische Rückmeldung über das Ergebnis.
    """
    # --- Addon-Datenpfad und Handle ermitteln ---
    addon_data_dir = None
    addon_handle = -1

    try:
        # Addon-Objekt holen
        addon = xbmcaddon.Addon()
        addon_name = addon.getAddonInfo('name') # Holt den tatsächlichen Namen
        # Datenpfad ermitteln
        addon_data_dir = xbmcvfs.translatePath(addon.getAddonInfo('profile'))
        # Sicherstellen, dass das Verzeichnis existiert
        if not xbmcvfs.exists(addon_data_dir):
            xbmcvfs.mkdirs(addon_data_dir)
            xbmc.log(f"[{addon_name}] Addon-Datenverzeichnis erstellt: {addon_data_dir}", xbmc.LOGINFO)
    except Exception as e:
        xbmc.log(f"[{addon_name}] Schwerwiegender Fehler: Konnte Addon-Objekt oder Datenpfad nicht ermitteln: {e}", xbmc.LOGERROR)
        xbmcgui.Dialog().notification(
            "Fehler",
            "Addon-Pfad nicht gefunden.",
            xbmcgui.NOTIFICATION_ERROR,
            5000
        )
        return # Funktion hier beenden, da der Pfad essentiell ist

    try:
        # Addon-Handle ermitteln (wird für endOfDirectory benötigt)
        # sys.argv[1] enthält normalerweise das Handle, wenn das Skript als Plugin aufgerufen wird
        if len(sys.argv) >= 2:
             addon_handle = int(sys.argv[1])
    except (IndexError, ValueError):
         xbmc.log(f"[{addon_name}] Konnte Addon-Handle nicht aus sys.argv ermitteln.", xbmc.LOGWARNING)
         addon_handle = -1 # Fallback

    # --- Eigentliche Reset-Logik ---
    watched_status_file = os.path.join(addon_data_dir, 'watched_status_series.json')
    xbmc.log(f"[{addon_name}] Prüfe/Lösche Gesehen-Status Datei: {watched_status_file}", xbmc.LOGINFO)

    try:
        # 1. Prüfen, ob die Datei existiert
        if xbmcvfs.exists(watched_status_file):
            # 2a. Ja, Datei existiert -> Löschen
            if xbmcvfs.delete(watched_status_file):
                # Erfolgreich gelöscht
                xbmc.log(f"[{addon_name}] Gesehen-Status-Datei erfolgreich gelöscht.", xbmc.LOGINFO)
                xbmcgui.Dialog().notification(
                    f"{addon_name}", # Titel (Addon-Name)
                    "Gesehen-Status wurde zurückgesetzt.", # Nachricht
                    xbmcgui.NOTIFICATION_INFO, # Icon
                    3000 # Anzeigedauer (3 Sek.)
                )
            else:
                # Fehler beim Löschen, obwohl Datei existiert (selten)
                xbmc.log(f"[{addon_name}] Fehler: Konnte existierende Datei nicht löschen: {watched_status_file}", xbmc.LOGERROR)
                xbmcgui.Dialog().notification(
                    f"{addon_name} - Fehler",
                    "Datei gefunden, aber Löschen fehlgeschlagen.",
                    xbmcgui.NOTIFICATION_ERROR,
                    5000
                )
        else:
            # 2b. Nein, Datei existiert nicht
            xbmc.log(f"[{addon_name}] Gesehen-Status-Datei nicht gefunden (Status war bereits zurückgesetzt).", xbmc.LOGINFO)
            xbmcgui.Dialog().notification(
                f"{addon_name}", # Titel (Addon-Name)
                "Nichts zu löschen!", # Nachricht
                xbmcgui.NOTIFICATION_INFO, # Icon
                3000 # Anzeigedauer (3 Sek.)
            )

    except Exception as e:
        # Allgemeine Fehlerbehandlung während des Datei-Checks/Löschens
        xbmc.log(f"[{addon_name}] Fehler beim Prüfen/Löschen der Gesehen-Status-Datei: {e}", xbmc.LOGERROR)
        import traceback
        xbmc.log(traceback.format_exc(), xbmc.LOGERROR) # Loggt den kompletten Traceback
        xbmcgui.Dialog().notification(
            f"{addon_name} - Fehler",
            f"Ein Fehler ist aufgetreten: {e}",
            xbmcgui.NOTIFICATION_ERROR,
            5000
        )

    # --- Abschluss (endOfDirectory) ---
    # Wird oft für Aktionen aus Settings nicht benötigt, aber beibehalten wie im Original
    if addon_handle != -1:
         xbmc.log(f"[{addon_name}] Aufruf von endOfDirectory mit Handle: {addon_handle}", xbmc.LOGDEBUG)
         xbmcplugin.endOfDirectory(addon_handle)
    else:
        xbmc.log(f"[{addon_name}] Kein gültiges Addon-Handle für endOfDirectory.", xbmc.LOGWARNING)

